/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking.dreadlamp;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.logic.DistanceLogics;
import net.xalcon.torchmaster.common.logic.entityblocking.IEntityBlockingLight;

public class DreadLampEntityBlockingLight
implements IEntityBlockingLight {
    public static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private BlockPos pos;

    public DreadLampEntityBlockingLight(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public boolean shouldBlockEntity(Entity entity, BlockPos pos) {
        return Torchmaster.DreadLampFilterRegistry.containsEntity(entity.m_6095_().getRegistryName()) && DistanceLogics.Cubic.isPositionInRange(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.pos, (Integer)TorchmasterConfig.GENERAL.dreadLampRadius.get());
    }

    @Override
    public boolean shouldBlockVillageSiege(BlockPos pos) {
        return false;
    }

    @Override
    public String getLightSerializerKey() {
        return "dreadlamp";
    }

    @Override
    public boolean cleanupCheck(Level level) {
        return level.m_46749_(this.pos) && level.m_8055_(this.pos).m_60734_() != ModBlocks.blockDreadLamp;
    }

    @Override
    public String getName() {
        return "Dread Lamp";
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }
}

